﻿using System;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using PpmsDataService.Models;
using PpmsDataService.ModelsEnumTypes;

namespace PpmsDataService.Models
{
    public class ProviderNetwork
    {
        [Key]
        public int NetworkId { get; set; }

        public string ProviderNetworkName { get; set; }

        public string ShortHand { get; set; }

        public string OperatingOrganizationName { get; set; }

        public NetworkType NetworkType { get; set; }

        public NetworkRegion NetworkRegion { get; set; }

        //Single
        public virtual IQueryable<Provider> OperatingOrganization { get; set; }

        //Many
        public virtual IQueryable<VaProviderRelationship> VaProviderRelationships { get; set; }

    }
}